#include "SAXTest.h"
#include "VFSMgr.h"

UInt16 SlotToVolRef(UInt16 slotRef);

typedef struct FileInfo
{
	FileRef	fileRef;
} FileInfo;

#define fileBlockSize	4096

/* Opens the file */
Boolean FP_OpenFile(Char* uri,UInt32 *pFileRef)
{
	Boolean retVal=true;
	MemHandle fileInfoH=MemHandleNew(sizeof(FileInfo));
	FileInfo* fileInfoP=(FileInfo*)MemHandleLock(fileInfoH);
	
	// Get slot reference
	Char slotRefStr[maxStrIToALen];
	UInt16	slotRefPos=0;
	while (*uri!='/')
	{
		if ((*uri>'9')||(*uri<'0')) 
		{
			retVal=false;
			break;
		}
		slotRefStr[slotRefPos++]=*(uri++);
		if (slotRefPos>=maxStrIToALen)
		{
			retVal=false;
			break;
		}
	}
	
	if (retVal)
	{
		slotRefStr[slotRefPos]=0x00;
		UInt16 slotRef=StrAToI(slotRefStr);
		UInt16 volRef=SlotToVolRef(slotRef);
		Err err=VFSFileOpen(volRef,uri,vfsModeRead,&fileInfoP->fileRef);
		if (err!=errNone)
		{
			retVal=false;
		}
	}
	
	MemHandleUnlock(fileInfoH);
	if (!retVal)
	{
		MemHandleFree(fileInfoH);
	}
	else
	{
		*pFileRef=(UInt32)fileInfoH;
	}
	return retVal;
}

/* Gets file block size */
UInt16 FP_GetFileBlockSize(UInt32 fileRef)
{
	return fileBlockSize;
}

/* Reads the next file block contents to the buffer */
Boolean FP_ReadFile(UInt32 fileRef,void *pBuf,UInt16 *readBytes)
{
	Boolean retVal=true;
	MemHandle fileInfoH=(MemHandle)fileRef;
	FileInfo* fileInfoP=(FileInfo*)MemHandleLock(fileInfoH);
	
	UInt32 bytes;
	Err err=VFSFileRead(fileInfoP->fileRef,*readBytes,pBuf,&bytes);
	if (((err==errNone)||(err==vfsErrFileEOF))&&(bytes!=0))
	{
		*readBytes=bytes;
	}
	else
	{
		*readBytes=0;
		retVal=false;
	}
	
	MemHandleUnlock(fileInfoH);
	return retVal;
}

/* Closes the opened file */
void FP_CloseFile(UInt32 fileRef)
{
	MemHandle fileInfoH=(MemHandle)fileRef;
	FileInfo* fileInfoP=(FileInfo*)MemHandleLock(fileInfoH);
	
	VFSFileClose(fileInfoP->fileRef);
	
	MemHandleUnlock(fileInfoH);
	MemHandleFree(fileInfoH);
}

/* Seeks to the specific position in the file */
Boolean FP_SeekFile(UInt32 fileRef,Int32 *offset)
{
	Boolean retVal=true;
	
	*offset=*offset/fileBlockSize*fileBlockSize;
	
	MemHandle fileInfoH=(MemHandle)fileRef;
	FileInfo* fileInfoP=(FileInfo*)MemHandleLock(fileInfoH);
	
	if (VFSFileSeek(fileInfoP->fileRef,vfsOriginBeginning,*offset)!=errNone)
	{
		retVal=false;
	}
	
	MemHandleUnlock(fileInfoH);
	MemHandleFree(fileInfoH);	
	
	return false;
}

/* Returns the file size */
UInt32 FP_GetFileSize(UInt32 fileRef)
{
	MemHandle fileInfoH=(MemHandle)fileRef;
	FileInfo* fileInfoP=(FileInfo*)MemHandleLock(fileInfoH);
	
	UInt32	size=0;
	VFSFileSize(fileInfoP->fileRef,&size);
	
	MemHandleUnlock(fileInfoH);
	return size;
}

UInt16 SlotToVolRef(UInt16 slotRef)
{
	UInt16	retVal=0;
	Err err;
	UInt16 volRefNum;
	UInt32 volIter=vfsIteratorStart;
	// Enumerate volumes
	do
	{
		err=VFSVolumeEnumerate(&volRefNum,&volIter);
		
		if (!err) 
		{
			// Labels are equal -- now compare slots
			VolumeInfoType	volInfo;
			VFSVolumeInfo(volRefNum,&volInfo);
			
			if (volInfo.slotRefNum==slotRef)
			{
				retVal=volRefNum;
				break;
			}
		}
		else break;
	}
	while (volIter!=vfsIteratorStop);
	return retVal;
}